// exampleR01.cc
// 2-Sep-1999 Bill Seligman
// Test the functionality of the RecorderBase class.

#include "ExR01DetectorConstruction.hh"
#include "ExR01RunAction.hh"
#include "ExR01PrimaryGeneratorAction.hh"
#include "ExR01PhysicsList.hh"
#include "ExR01SteppingAction.hh"

#include "ExR01Histograms.hh"
#include "RecorderBase.hh"

#include "G4RunManager.hh"

int main(int ,char** ) {

  // Create the RecorderBase object (which in this example will
  // make histograms).
  RecorderBase * myRecords = new ExR01Histograms;

  // Run manager
  G4RunManager * runManager = new G4RunManager;

  // UserInitialization classes
  runManager->SetUserInitialization(new ExR01DetectorConstruction);
  runManager->SetUserInitialization(new ExR01PhysicsList); 

  // UserAction classes.
  // Note that we pass the RecorderBase object to the user actions that
  // will invoke it.
  runManager->SetUserAction(new ExR01RunAction(myRecords));
  runManager->SetUserAction(new ExR01PrimaryGeneratorAction);
  runManager->SetUserAction(new ExR01SteppingAction(myRecords));
 
  // Event loop
  G4int n_event = 1000;
  runManager->Initialize();
  runManager->BeamOn(n_event);

  delete runManager;
  delete myRecords;
  return 0;
}
