// ExR01Histograms.hh
// 01-Sep-99 Bill Seligman
// This is an example class for booking histograms in GEANT4.
// It functions by implementing an abstract RecorderBase class
// with concrete methods to record histograms.

#ifndef ExR01Histograms_h
#define ExR01Histograms_h 1

// The RecorderBase object.  We're implementing this abstract class
// with methods that fill histograms.
#include "RecorderBase.hh"

// Include the CLHEP Histogram classes
#include "CLHEP/Hist/Histogram.h"
#include "CLHEP/Hist/Tuple.h"
#include "CLHEP/Hist/HBookFile.h"

// For the random numbers in the filling example.
#include "Randomize.hh"
#include "globals.hh"

// These are needed because they're arguments to the methods in
// the RecorderBase class that we plan to use.  In real life, we
// might use the variables in G4Run or G4Step to 
// histogram or otherwise record values.
#include "G4Run.hh"
#include "G4Step.hh"

class ExR01Histograms: public RecorderBase
{
public:
  ExR01Histograms();
  virtual ~ExR01Histograms();

  // For this example, we're opening and closing our HBOOK file
  // at the start and end of a run, respectively.
  void RecordBeginOfRun(const G4Run *); 
  void RecordEndOfRun(const G4Run *); 

  // For this example, we're filling a histogram every time Geant4
  // calls the UserSteppingAction procedures.
  void RecordStep(const G4Step *);

private:
  HBookFile * hfile;   // The file for our histograms and ntuples. 

  // Our StepFill example is not very practical; we're
  // only going to histogram random numbers.
  HepHistogram * myHisto1D;  // A sample 1D histogram. 
  HepHistogram * myHisto2D;  // A sample 2D histogram.
  HepTuple * myTuple;        // A sample ntple.

  // For the random numbers in StepFill.
  HepJamesRandom theJamesEngine;
  DRand48Engine theDRand48Engine;

};

#endif
