
#ifndef ExR01RunAction_h
#define ExR01RunAction_h 1

#include "G4UserRunAction.hh"
#include "globals.hh"

#include "RecorderBase.hh"

class G4Run;

class ExR01RunAction : public G4UserRunAction
{
  public:

    // If the constructor is called with a RecorderBase object,
    // then there will be record-keeping performed in the
    // BeginOfRunAction and EndOfRunAction.
    ExR01RunAction() {records = NULL;}
    ExR01RunAction(RecorderBase * r) {records = r;}

    virtual ~ExR01RunAction() {}

    virtual void BeginOfRunAction(const G4Run* aRun);
    virtual void EndOfRunAction(const G4Run* aRun);

  private:

    // Save the RecorderBase object to be called at the beginning
    // and end of the run.
    RecorderBase * records;

};

#endif

