
#ifndef ExR01SteppingAction_h
#define ExR01SteppingAction_h 1

#include "G4UserSteppingAction.hh"
#include "globals.hh"
#include "RecorderBase.hh"

class ExR01SteppingAction : public G4UserSteppingAction {

private:

  // Save the RecorderBase object to be called by the UserSteppingAction.
  RecorderBase * records;

public:

  // If the constructor is called with a RecordBase arguement,
  // then we'll perform some record keeping in UserSteppingAction.
  ExR01SteppingAction() {records = NULL;}
  ExR01SteppingAction(RecorderBase * r) {records = r;}

  virtual ~ExR01SteppingAction(){};
  
  virtual void UserSteppingAction(const G4Step*);
};

#endif
