// exampleR02.cc
// 15-Sep-1999 Bill Seligman
// Use the RecorderBase class for simple variable displays.

#include "ExR02DetectorConstruction.hh"
#include "ExR02RunAction.hh"
#include "ExR02PrimaryGeneratorAction.hh"
#include "ExR02PhysicsList.hh"
#include "ExR02EventAction.hh"
#include "ExR02SteppingAction.hh"

#include "ExR02Variables.hh"
#include "RecorderBase.hh"

#include "G4RunManager.hh"

int main(int ,char** ) {

  // Create the RecorderBase object (which in this example will
  // record and display some variables).
  RecorderBase * myRecords = new ExR02Variables;

  // Run manager
  G4RunManager * runManager = new G4RunManager;

  // UserInitialization classes
  runManager->SetUserInitialization(new ExR02DetectorConstruction);
  runManager->SetUserInitialization(new ExR02PhysicsList); 

  // UserAction classes.
  // Note that we pass the RecorderBase object to the user actions that
  // will invoke it.
  runManager->SetUserAction(new ExR02RunAction(myRecords));
  runManager->SetUserAction(new ExR02PrimaryGeneratorAction);
  runManager->SetUserAction(new ExR02EventAction(myRecords));
  runManager->SetUserAction(new ExR02SteppingAction(myRecords));
 
  // Event loop
  G4int n_event = 10;
  runManager->Initialize();
  runManager->BeamOn(n_event);

  delete runManager;
  delete myRecords;
  return 0;
}
