
#ifndef ExR02EventAction_h
#define ExR02EventAction_h 1

#include "G4UserEventAction.hh"
#include "globals.hh"

#include "RecorderBase.hh"

class G4Event;

class ExR02EventAction : public G4UserEventAction
{
  public:

    // If the constructor is called with a RecorderBase object,
    // then there will be record-keeping performed in the
    // BeginOfEventAction and EndOfEventAction.
    ExR02EventAction() {records = NULL;}
    ExR02EventAction(RecorderBase * r) {records = r;}

    virtual ~ExR02EventAction() {}

    virtual void BeginOfEventAction(const G4Event* anEvent);
    virtual void EndOfEventAction(const G4Event* anEvent);

  private:

    // Save the RecorderBase object to be called at the beginning
    // and end of the event.
    RecorderBase * records;

};

#endif

