
#ifndef ExR02RunAction_h
#define ExR02RunAction_h 1

#include "G4UserRunAction.hh"
#include "globals.hh"

#include "RecorderBase.hh"

class G4Run;

class ExR02RunAction : public G4UserRunAction
{
  public:

    // If the constructor is called with a RecorderBase object,
    // then there will be record-keeping performed in the
    // BeginOfRunAction and EndOfRunAction.
    ExR02RunAction() {records = NULL;}
    ExR02RunAction(RecorderBase * r) {records = r;}

    virtual ~ExR02RunAction() {}

    virtual void BeginOfRunAction(const G4Run* aRun);
    virtual void EndOfRunAction(const G4Run* aRun);

  private:

    // Save the RecorderBase object to be called at the beginning
    // and end of the run.
    RecorderBase * records;

};

#endif

