
#ifndef ExR02SteppingAction_h
#define ExR02SteppingAction_h 1

#include "G4UserSteppingAction.hh"
#include "globals.hh"
#include "RecorderBase.hh"

class ExR02SteppingAction : public G4UserSteppingAction {

private:

  // Save the RecorderBase object to be called by the UserSteppingAction.
  RecorderBase * records;

public:

  // If the constructor is called with a RecordBase arguement,
  // then we'll perform some record keeping in UserSteppingAction.
  ExR02SteppingAction() {records = NULL;}
  ExR02SteppingAction(RecorderBase * r) {records = r;}

  virtual ~ExR02SteppingAction(){};
  
  virtual void UserSteppingAction(const G4Step*);
};

#endif
