// ExR02Variables.hh
// 15-Sep-99 Bill Seligman
// This is an example class for user display of variables in Geant4.
// It functions by implementing an abstract RecorderBase class
// with concrete methods to display variables..

#ifndef ExR02Variables_h
#define ExR02Variables_h 1

// The RecorderBase object.  We're implementing this abstract class
// with methods that display variables.
#include "RecorderBase.hh"

#include "globals.hh"

#include "G4Run.hh"
#include "G4Event.hh"
#include "G4Step.hh"

class ExR02Variables: public RecorderBase
{
public:
  ExR02Variables();
  virtual ~ExR02Variables();

  // For this example, we'll write a title at the beginning of each run.
  void RecordBeginOfRun(const G4Run *); 
  void RecordEndOfRun(const G4Run *); 

  // For this example, we'll zero out a variable at the beginning of an
  // event, and display it at the end.
  void RecordBeginOfEvent(const G4Event *); 
  void RecordEndOfEvent(const G4Event *); 

  // For this example, we're incrementing a variable with each step.
  void RecordStep(const G4Step *);

private:

  // Variables to keep track of during an event.
  G4double stepEnergy;

};

#endif
