// ExR02Variables.cc
// 15-Sep-99 Bill Seligman
// This is an example class for displaying variables in GEANT4.

#include "ExR02Variables.hh"

#include "globals.hh"

#include "G4Run.hh"
#include "G4Event.hh"
#include "G4Step.hh"
#include "G4ios.hh"
#include <iomanip.h>

// The constructor and destructor of this class don't need
// to do anything.  (Unlike the histogram example, there are no
// private pointer variables to keep track of.)
ExR02Variables::ExR02Variables() {}
ExR02Variables::~ExR02Variables() {}


void ExR02Variables::RecordBeginOfRun(const G4Run* run)
{
  cout << "Display of events for Run #" << run->GetRunID() << " (100 GeV e-)\n";
}


void ExR02Variables::RecordEndOfRun(const G4Run* run)
{
  cout << "End of Run #" << run->GetRunID() << "\n\n";
}


void ExR02Variables::RecordBeginOfEvent(const G4Event* event)
{
  stepEnergy = 0;
}


void ExR02Variables::RecordEndOfEvent(const G4Event* event)
{
  cout << "Event #" << event->GetEventID() << 
    " total energy=" << stepEnergy << " GeV\n";
}


void ExR02Variables::RecordStep(const G4Step* step) {

  stepEnergy += step->GetTotalEnergyDeposit() / GeV;
}
