// exampleR03.cc
// 2-Sep-1999 Bill Seligman
// Test the functionality of the RecorderBase class.

#include "ExR03DetectorConstruction.hh"
#include "ExR03RunAction.hh"
#include "ExR03PrimaryGeneratorAction.hh"
#include "ExR03PhysicsList.hh"
#include "ExR03SteppingAction.hh"

#include "ExR03Histograms.hh"
#include "RecorderBase.hh"

#include "G4RunManager.hh"

int main(int ,char** ) {

  // Create the RecorderBase object (which in this example will
  // make histograms).
  RecorderBase * myRecords = new ExR03Histograms;

  // Run manager
  G4RunManager * runManager = new G4RunManager;

  // UserInitialization classes
  runManager->SetUserInitialization(new ExR03DetectorConstruction);
  runManager->SetUserInitialization(new ExR03PhysicsList); 

  // UserAction classes.
  // Note that we pass the RecorderBase object to the user actions that
  // will invoke it.
  runManager->SetUserAction(new ExR03RunAction(myRecords));
  runManager->SetUserAction(new ExR03PrimaryGeneratorAction);
  runManager->SetUserAction(new ExR03SteppingAction(myRecords));
 
  // Event loop
  G4int n_event = 1000;
  runManager->Initialize();
  runManager->BeamOn(n_event);

  delete runManager;
  delete myRecords;
  return 0;
}
