// ExR03Histograms.hh
// 01-Sep-99 Bill Seligman
// This is an example class for booking histograms in GEANT4
// using ROOT.  It is based on ${ROOTSYS}/test/hsimple.cxx.

#ifndef ExR03Histograms_h
#define ExR03Histograms_h 1

// The RecorderBase object.  We're implementing this abstract class
// with methods that fill histograms.
#include "RecorderBase.hh"

// Include files for ROOT.
#include "TROOT.h"
#include "TFile.h"
#include "TH1.h"
#include "TH2.h"
#include "TProfile.h"
#include "TNtuple.h"
#include "TRandom.h"

#include "globals.hh"

// These are needed because they're arguments to the methods in
// the RecorderBase class that we plan to use.  In real life, we
// might use the variables in G4Run or G4Step to 
// histogram or otherwise record values.
#include "G4Run.hh"
#include "G4Step.hh"

class ExR03Histograms: public RecorderBase
{
public:
  ExR03Histograms();
  virtual ~ExR03Histograms();

  // For this example, we're opening and closing our HBOOK file
  // at the start and end of a run, respectively.
  void RecordBeginOfRun(const G4Run *); 
  void RecordEndOfRun(const G4Run *); 

  // For this example, we're filling a histogram every time Geant4
  // calls the UserSteppingAction procedures.
  void RecordStep(const G4Step *);

private:
  TFile * hfile;   // The file for our histograms and ntuples. 

  // Our StepFill example is not very practical; we're
  // only going to histogram random numbers.
  TH1F * myHisto1D;   // A sample 1D histogram. 
  TH2F * myHisto2D;   // A sample 2D histogram.
  TProfile * myProf;  // Profile histogram.
  TNtuple * myTuple;  // A sample ntuple.

  Int_t countCall;    // Count the number of times we call RecordStep.
  // Note that Int_t is a ROOT type (as opposed to G4int, which is a GEANT4 type).
};

#endif
