
#ifndef ExR03SteppingAction_h
#define ExR03SteppingAction_h 1

#include "G4UserSteppingAction.hh"
#include "globals.hh"
#include "RecorderBase.hh"

class ExR03SteppingAction : public G4UserSteppingAction {

private:

  // Save the RecorderBase object to be called by the UserSteppingAction.
  RecorderBase * records;

public:

  // If the constructor is called with a RecordBase arguement,
  // then we'll perform some record keeping in UserSteppingAction.
  ExR03SteppingAction() {records = NULL;}
  ExR03SteppingAction(RecorderBase * r) {records = r;}

  virtual ~ExR03SteppingAction(){};
  
  virtual void UserSteppingAction(const G4Step*);
};

#endif
