
#include "ExR03RunAction.hh"
#include "G4Run.hh"
#include "G4UImanager.hh"
#include "G4ios.hh"

#include "RecorderBase.hh"

void ExR03RunAction::BeginOfRunAction(const G4Run* aRun)
{
  G4UImanager* UI = G4UImanager::GetUIpointer();
  UI->ApplyCommand("/event/Verbose 0");
  UI->ApplyCommand("/tracking/Verbose 0");

  // Initiate record-keeping for this run.
  if (records != NULL) records->RecordBeginOfRun(aRun);
}

void ExR03RunAction::EndOfRunAction(const G4Run* aRun)
{
  // Terminate record-keeping for this run.
  if (records != NULL) records->RecordEndOfRun(aRun);
}


