{
// Simple display of histograms from exampleR04
// 03-Oct-2000 Bill Seligman

// This is not the greatest of all histogram displays, but it's enough
// to tell you that all three plots for a given run are the same.

gROOT->Reset();
c1 = new TCanvas("Run0","One 200-MeV e+",           10, 10,1200,400);
c2 = new TCanvas("Run1","One 1-TeV mu+",            30, 90,1200,400);
c3 = new TCanvas("Run2","One hundred 200-MeV e+'s", 50,170,1200,400);
c4 = new TCanvas("Run3","One hundred 1-TeV mu+'s",  70,250,1200,400);

TFile *f = new TFile("exampleR04.root");
f->ls();

// Divide each canvas into 3 sub-pads, and display a plot in each pad.
c1->Divide(3,1);
c1->cd(1); Hits0->Draw();
c1->cd(2); Track0->Draw();
c1->cd(3); Tot0->Draw();

c2->Divide(3,1);
c2->cd(1); Hits1->Draw();
c2->cd(2); Track1->Draw();
c2->cd(3); Tot1->Draw();

c3->Divide(3,1);
c3->cd(1); Hits2->Draw();
c3->cd(2); Track2->Draw();
c3->cd(3); Tot2->Draw();

c4->Divide(3,1);
c4->cd(1); Hits3->Draw();
c4->cd(2); Track3->Draw();
c4->cd(3); Tot3->Draw();

c5 = new TCanvas("Expl","A word of explanation",    10,600,800,400);
pave1 = new TPaveText(0.05,0.05,0.95,0.95);
pave1->SetTextSize(0.05);
pave1->SetTextAlign(12);
pave1->AddText("Note:");
pave1->AddText("If you use the ExN02DetectorConstruction class from the original exampleN02,");
pave1->AddText("then all three of the histograms within a run will be almost the same. This is ");
pave1->AddText("because the detector consists of aluminum plates separated by air, and the ");
pave1->AddText("'sensitive detector' used to record hits are those same plates. Therefore, ");
pave1->AddText("the only energy deposited in the detector is in the plates in all three ");
pave1->AddText("histograms. The only (slight) difference is that hits are not recorded within");
pave1->AddText("the target at z=0.");
pave1->Draw();
}
