// ExR04Histograms.hh
// 29-Sep-2000 Bill Seligman
// This is an example class for booking histograms in GEANT4
// using ROOT.

#ifndef ExR04Histograms_h
#define ExR04Histograms_h 1

// The RecorderBase object.  We're implementing this abstract class
// with methods that fill histograms.
#include "RecorderBase.hh"

// Forward declarations for ROOT.
class TFile;
class TH1D;

// Forward declarations of G4 classes that are arguments to
// RecorderBase methods.
class G4Run;
class G4Event;
class G4Step;

class ExR04Histograms: public RecorderBase
{
public:
  ExR04Histograms();
  virtual ~ExR04Histograms();

  // For this example, we're opening and closing our HBOOK file at the
  // start and end of a run, respectively.  We're filling histograms
  // in the UserEndOfEvent and UserSteppingAction classes.
  virtual void RecordBeginOfRun(const G4Run *); 
  virtual void RecordEndOfRun(const G4Run *); 
  virtual void RecordEndOfEvent(const G4Event*);
  virtual void RecordStep(const G4Step*);

private:
  TFile * m_histFile;   // The file for our histograms and ntuples. 

  // In this example, we're going to create histograms of
  // energy vs. Z for each run.
  TH1D * m_eHitHist;
  TH1D * m_eTrackHist;
  TH1D * m_eTotHist;
};

#endif
