
#include "ExR04EventAction.hh"
#include "RecorderBase.hh"

#include "G4Event.hh"
#include "G4EventManager.hh"
#include "G4TrajectoryContainer.hh"
#include "G4Trajectory.hh"
#include "G4VVisManager.hh"
#include "G4UImanager.hh"
#include "G4ios.hh"


ExR04EventAction::ExR04EventAction(RecorderBase* r) : recorder(r)
{}

ExR04EventAction::~ExR04EventAction()
{}

void ExR04EventAction::BeginOfEventAction(const G4Event*)
{}

void ExR04EventAction::EndOfEventAction(const G4Event* evt)
{
  G4int event_id = evt->GetEventID();

  G4TrajectoryContainer * trajectoryContainer = evt->GetTrajectoryContainer();
  G4int n_trajectories = 0;
  if (trajectoryContainer) n_trajectories = trajectoryContainer->entries();

  if (event_id < 100 || event_id%100 == 0) {

    G4cout << ">>> Event " << evt->GetEventID() << G4endl;
  
    G4cout << "    " << n_trajectories 
	   << " trajectories stored in this event." << G4endl;
  }

  G4VVisManager* pVVisManager = G4VVisManager::GetConcreteInstance();

  if(pVVisManager)
  {
    for(G4int i=0; i<n_trajectories; i++)
    { (*(evt->GetTrajectoryContainer()))[i]->DrawTrajectory(50); }
  }

  // Do any necessary record-keeping.
  if (recorder != 0) recorder->RecordEndOfEvent(evt);
}
