
#include "ExR04SteppingAction.hh"
#include "ExN02DetectorConstruction.hh"
#include "ExR04EventAction.hh"
#include "RecorderBase.hh"

#include "G4SteppingManager.hh"

ExR04SteppingAction::ExR04SteppingAction(ExN02DetectorConstruction* myDC, 
					 ExR04EventAction* myEA, 
					 RecorderBase* r)
  :myDetector(myDC), eventAction(myEA), recorder(r)
{ }

void ExR04SteppingAction::UserSteppingAction(const G4Step* a_Step)
{
  // collect the energy deposited in the absorber
  
  const G4VPhysicalVolume* currentVolume = a_Step->GetPreStepPoint()-> GetPhysicalVolume();

#if 0
  const G4VPhysicalVolume* absorber = myDetector->getAbsorber();

  if (currentVolume == absorber)
   {
    G4double EdepStep = a_Step->GetTotalEnergyDeposit();
    eventAction->addEdep(EdepStep);
   } 
#endif

  // Perform any recording necessary for this step.
  if (recorder != 0) recorder->RecordStep(a_Step);
}
