{
  // Simple display of events from exampleR05
  // 03-Oct-2000 Bill Seligman
  gROOT->Reset();
  
  // For some reason, the physics library is not pre-loaded into ROOT.
  gSystem.Load("$ROOTSYS/lib/libPhysics.so");
  
  // Load the definitions of our custom classes.
  gSystem.Load("ExR05.so");

  // Display them (a clumsy way to imbed a ROOT command in a CINT file)
  // TExec("ex1",".class ExR05RootEvent")->Exec();
  // TExec("ex2",".class ExR05RootHit")->Exec();

  TFile* f = new TFile("exampleR05.root");
  f->ls();

  TString treeNum = "2";  // You can change this to "0", "1", "2", or "3".

  TTree* myTree = (TTree*)f->Get("Tree" + treeNum);
  myTree->Print();

  // The "event" below is the type of branch (trees, leaves, branches,
  // events), and not the name of a particular class.
  TBranch* eventBranch = myTree->GetBranch("event");

  // We wrote the tree with splitLevel=1, so we can pick out one data
  // element as a branch.
  TBranch* hitBranch = myTree->GetBranch("m_hits");

  // Create a memory "buffer" for reading our tree.
  ExR05RootEvent* myEvent = new ExR05RootEvent();
  eventBranch->SetAddress(&myEvent);

  // Read an event.  Note how the "Print" method of the event comes from
  // the definition of the ExR05RootEvent class (it was was brought in
  // with ExR05.so).
  myTree->GetEvent(0);
  myEvent->Print();

  eventBranch->GetEvent(0); // does the same thing
  myEvent->Print();

  // When I read through the "m_hits" branch, instead of through the
  // entire event, only m_hits changes.  The memory region of myEvent
  // is also the buffer for individual branches of the event.
  hitBranch->GetEvent(0);
  myEvent->Print();

  // Note how the number of hits changes (for Tree #2 or #3), though the
  // event ID does not; "hitBranch->GetEvent" only reads the m_hits, but
  // nothing else.
  hitBranch->GetEvent(1);
  myEvent->Print();

  // Let's make a histogram (compare with example R04).
  TH1D* hitHist = new TH1D("Hist" + treeNum,
			   "z-distribution of energy deposited by hits",240,0.,600.);
  hitHist->SetXTitle("z-position [cm]");
  hitHist->SetYTitle("Energy [GeV]");

  // Work variables for filling the histogram.
  Int_t numEvents = myTree->GetEntries();
  Int_t numHits;
  Stat_t edep;
  Axis_t zpos;
  ExR05RootHit* aHit;

  // For each event in the tree...
  for (Int_t i = 0; i < numEvents; i++)
    {
      myTree->GetEvent(i); // Read in an event.
      // For each hit in the event...
      numHits = myEvent->GetNumberHits();
      for (Int_t j = 0; j < numHits; j++) 
	{
	  // Note how reading the ExR05RootEvent caused its
	  // TOrdCollection of ExR05RootHits to be brought in as well.
	  // All the pointers were correctly set by ROOT's I/O
	  // mechanism.
	  aHit = myEvent->GetHit(j);
	  edep = aHit->GetEnergy();
	  zpos = aHit->Z();
	  hitHist->Fill(zpos,edep);
	}
    }

  hitHist->Draw();

  // Create the HTML documentation for our ROOT classes.  ROOT provides
  // a facility for creating the documentation for an entire directory
  // of code at once, but we don't use that here since only a couple of
  // exampleR05's classes are ROOT-based.

  // MakeAll is interesting, but it generates output for all the classes
  // loaded in memory.

  THtml* html = new THtml();
  html->SetOutputDir( "./htmldoc" );
  html->MakeClass("ExR05RootEvent");
  html->MakeClass("ExR05RootHit");
  //html->MakeAll();


  // Another demonstration: Let ROOT write some analysis code for us
  // using MakeClass.  The following will create a ".h" and ".C" file,
  // which can then be edited manually to suit a particular analysis
  // task.
  myTree->MakeClass("ExR05MakeClass");

}
