// ExR05PersistentRootHit.hh
// Convert a ExN02TrackerHit into a ExR05RootHit
// 20-Oct-2000 Bill Seligman


#ifndef _EXR05PERSISTENTROOTHIT_H_
#define _EXR05PERSISTENTROOTHIT_H_

#include "ExR05RootHit.hh"

// This class will have to "know" all the different types of hits
// there are (it's a bit tricky make it a function of G4VHit, though
// if this class implemented a hit collection conversion, instead of
// converting one hit at a time, it would be possible).
class ExN02TrackerHit;

class ExR05PersistentRootHit: public ExR05RootHit
{
  // This class is a "wrapper" for an example ROOT hit class.  It's
  // needed because if ExR05RootHit had any reference to G4 classes,
  // we would not be able to use rootcint and other ROOT tools on that
  // class.
public:
  // Typically, with this approach we'll have a different constructor
  // for each type of hit.
  ExR05PersistentRootHit(const ExN02TrackerHit*);
  virtual ~ExR05PersistentRootHit();
};

#endif // _EXR05PERSISTENTROOTHIT_H_
