// ExR05RootEvent
// A simple example event class to use with ROOT and Geant4.
// 18-Oct-2000 Bill Seligman

#ifndef _EXR05ROOTEVENT_H_
#define _EXR05ROOTEVENT_H_

// This class can be used with ROOT's dictionary generation, built-in
// I/O, and RTTI (Run-Time Type Identification).  To enable this
// functionality, this class must be derived from class TObject, and
// all its members must also be derived from TObject.
#include "TObject.h"
// Don't do a forward declaration of TOrdCollection here.  If you do,
// the class dictionary won't compiler properly.
#include "TOrdCollection.h"

// Forward declarations.
class ExR05RootHit;

class ExR05RootEvent : public TObject 
{
public:

  // Important: A ROOT-compatible class must have a default
  // zero-argument constructor defined, that is, a constructor with
  // either no arguments or one for which all the arguments have
  // default values.
  ExR05RootEvent();
  virtual ~ExR05RootEvent();

  // Accessor methods.  Note the lack of any public "set" methods.
  // This is a crude form of "locking" the contents of this class;
  // once an event is created, I don't want any other programs to
  // change its values.  (A real application would have a more
  // sophisticated approach; e.g., a reconstruction program would need
  // to add tracks, momenta, vertices, etc.)
  Int_t GetRunID() const { return m_runNumber; }
  Int_t GetEventID() const { return m_eventNumber; }
  Int_t GetNumberHits() const;
  ExR05RootHit* GetHit(Int_t a_hitNumber) const;
  TOrdCollection* GetHitCollection() const { return m_hits; }
  void Print(Option_t* a_option="") const; // options="hits" means to print hits as well

  // The following data members are protected, not public, because I
  // inherit a Geant4-ROOT "persistency" class from this one.  It is
  // this persistency class that will set the values of the data
  // memebers.
protected:
  void SetRunID(Int_t r) {m_runNumber = r;}
  void SetEventID(Int_t e) {m_eventNumber = e;}
  void AdoptHit(ExR05RootHit* h); // Add hit to event and adopt its pointer (the event will delete it)

private:
  Int_t m_runNumber;   // Geant4 run number
  Int_t m_eventNumber; // Geant4 event number
  TOrdCollection* m_hits; // Collection of hits for this event.

public:
  // The following is a macro defined in TObject.h.  The second number
  // is the "version number" of this class definition; if we change
  // the class, we should increment the version number.  This allows
  // ROOT to read files created with several different versions of a
  // class (very handy for reading old files during the course of an
  // experiment's analysis!).
  ClassDef(ExR05RootEvent,1) // Simple event class for example R05
};

#endif // _EXR05ROOTEVENT_H_
