// ExR05RootPersistency.hh
// 29-Sep-2000 Bill Seligman
// This is an example class for booking histograms in GEANT4
// using ROOT.

#ifndef ExR05RootPersistency_h
#define ExR05RootPersistency_h 1

// The RecorderBase object.  We're implementing this abstract class
// with methods that fill histograms.
#include "RecorderBase.hh"

// Forward declarations for ROOT.
class TFile;
class TTree;

// Forward declaration of main branches of tree.
class ExR05PersistentRootEvent;

// Forward declarations of G4 classes that are arguments to
// RecorderBase methods.
class G4Run;
class G4Event;

class ExR05RootPersistency: public RecorderBase
{
public:
  ExR05RootPersistency();
  virtual ~ExR05RootPersistency();

  // For this example, we're opening and closing our HBOOK file at the
  // start and end of a run, respectively.  We're filling histograms
  // in the UserEndOfEvent and UserSteppingAction classes.
  virtual void RecordBeginOfRun(const G4Run *); 
  virtual void RecordEndOfRun(const G4Run *); 
  virtual void RecordEndOfEvent(const G4Event*);

private:
  TFile* m_rootFile;   // The file for our tree(s).
  TTree* m_tree;       // The tree of our Geant4 events.

  ExR05PersistentRootEvent* m_rootEvent; // Address of event written to tree.
};

#endif
