// ExR05PersistentRootEvent.hh
// Convert a G4Event into a ExR05RootEvent
// 20-Oct-2000 Bill Seligman

/// Classes needed to convert hit information.
#include "ExR05PersistentRootEvent.hh"
#include "ExR05RootEvent.hh"

// Classes needed to access event information.
#include "G4Event.hh"
#include "G4RunManager.hh"
#include "G4Run.hh"

// Classes needed for access and convert hit information.
#include "ExR05PersistentRootHit.hh"
#include "G4SDManager.hh"
#include "G4HCofThisEvent.hh"
#include "ExN02TrackerHit.hh"

ExR05PersistentRootEvent::ExR05PersistentRootEvent(const G4Event* a_event) 
  : ExR05RootEvent() // Invoke the base class constructor first.
{
  // Here's the meat inside the wrapper: How to convert a G4Event into
  // our sample root event.
  G4RunManager* rm = G4RunManager::GetRunManager();
  SetRunID( rm->GetCurrentRun()->GetRunID() );
  SetEventID( a_event->GetEventID() );

  // Access the Hit Collection of this event
  // (from section 3.12.4.2 of the Geant4 Users' Guide).

  // First, get the pointer to the singleton Sensitive Detector Manager.
  G4SDManager* fSDM = G4SDManager::GetSDMpointer();

  // Get the collection ID number for the particular type of hit
  // we're interested in.  "trackerCollection" was defined to be the
  // name of a hit collection in ExN02TrackerSD.cc.  If there were
  // many types of hits (e.g., calorimeter hits, chamber hits, etc.)
  // then the following code could be repeated as needed for each
  // type.
  G4int collectionID = fSDM->GetCollectionID("trackerCollection");

  // Get the pointer to the hit collections of this event.
  G4HCofThisEvent* HCofEvent = a_event->GetHCofThisEvent();

  // Get the hit collection that corresponds to the particular collection ID number.
  // Note the type cast that converts the "G4VHitsCollection*" returned by GetHC
  // into a pointer to our custom type of hit collection.
  ExN02TrackerHitsCollection* trackerHC = 
    (ExN02TrackerHitsCollection*) (HCofEvent->GetHC(collectionID));

  // For this example, we want to loop through all the tracker hits.
  // Get the number of hits in this hit collection.
  G4int numberHits = trackerHC->entries();

  for (G4int i = 0; i < numberHits; i++)
    {
      // Get the "i-th" hit in the collection.
      ExN02TrackerHit* hit = (*trackerHC)[i];

      // Convert it one of our ROOT hits.
      ExR05PersistentRootHit* rootHit = new ExR05PersistentRootHit(hit);

      // Add the hit to our event.
      AdoptHit(rootHit);
    }

}

ExR05PersistentRootEvent::~ExR05PersistentRootEvent() {;}
