// ExR05PersistentRootHit.hh
// Convert a G4-style hit into a ExR05RootHit
// 24-Oct-2000 Bill Seligman

/// Classes needed to convert hit information.
#include "ExR05PersistentRootHit.hh"
#include "ExR05RootHit.hh"

// Classes needed for access and convert hit information.
#include "ExN02TrackerHit.hh"
#include "G4ThreeVector.hh"
#include "globals.hh"

// Example R05 only processes one type of hit.  A real example might
// include one constructor for each type of hit in the application.  A
// sophisticated approach would involve accepting a G4VHitCollection
// pointer, casting it into an appropriate type, and setting the
// ExR05RootEvent's TCollection pointer.

ExR05PersistentRootHit::ExR05PersistentRootHit(const ExN02TrackerHit* a_hit) 
  : ExR05RootHit() // Invoke the base class constructor first.
{
  // Here's the meat inside the wrapper: How to convert the hits.
  // Note that we convert the units here; ROOT does not know the
  // Geant4 unit system.
  SetEnergy(a_hit->GetEdep() / GeV);
  G4ThreeVector position = a_hit->GetPos();
  SetPosition(position.x() / cm, position.y() / cm, position.z() / cm);
}

ExR05PersistentRootHit::~ExR05PersistentRootHit() {;}
