//_____________________________________________________________
// ExR05RootHit
//
// A simple example hit class to use with ROOT and Geant4.
// 18-Oct-2000 Bill Seligman
//
// More Geant4+ROOT examples can be found at the 
// begin_html <a href="http://www.nevis.columbia.edu/~atlas/lar/">ATLAS LAr Software at Nevis</a> end_html 
// web page.

// Note that when using ROOT's automatic documentation facility,
// comments at the top of the source file preceeded by
// ""//______________________" will become the class documentation.
// Comments immediately following the opening brace ({) of a member
// description become the member documentation.

#include "ExR05RootHit.hh"
#include "ExR05RootEvent.hh"

#include "TString.h"
#include "TVector3.h"

#include <iostream>

// This class can be used with ROOT's dictionary generation, built-in
// I/O, and RTTI (Run-Time Type Identification).  To enable this
// functionality, this class must be derived from class TObject, all
// its members must also be derived from TObject, and the following
// macro (defined in TObject.h) must be included.
ClassImp(ExR05RootHit)

ExR05RootHit::ExR05RootHit()
{
  // Class constructor.  Creates an empty hit.
  m_energyDeposit = 0;
  m_position = TVector3(0.,0.,0.);
}

ExR05RootHit::~ExR05RootHit() {;}

void ExR05RootHit::Print(Option_t* a_option) const
{
  // Print the hit.
  std::cout << "Energy=" << m_energyDeposit
	    << ", x=" << m_position.X()
	    << ", y=" << m_position.Y()
	    << ", z=" << m_position.Z() << endl;
} 

