// --------------------------------------------------------------
//      GEANT 4 - exampleR05
// --------------------------------------------------------------
// 29-Sep-2000 Bill Seligman
// This is the main program of a sample package to show how to use
// the RecorderBase class, Geant4 hits, and ROOT all together.

#include "ExN02DetectorConstruction.hh"
#include "ExN02PhysicsList.hh"
#include "ExR05RunAction.hh"
#include "ExN02PrimaryGeneratorAction.hh"
#include "ExR05EventAction.hh"
#include "ExN02SteppingVerbose.hh"

#include "ExR06RootPersistency.hh"
#include "RecorderBase.hh"

#include "G4UImanager.hh"
#include "G4UIterminal.hh"
#include "G4UItcsh.hh"

#include "G4RunManager.hh"
#ifdef G4VIS_USE
#include "ExN02VisManager.hh"
#endif

#include "G4ios.hh"


int
main(int argc,char** argv) {

  //my Verbose output class
  G4VSteppingVerbose::SetInstance(new ExN02SteppingVerbose);

  // Create the RecorderBase object, which in this example will write
  // events in a ROOT-compatible format.  Note that if we wished to
  // work with a different persistency model (e.g., Objectivity,
  // HepOBDMS), all we have to do is change the following statement
  // below (and code the classes).
  RecorderBase * myRecords = new ExR06RootPersistency;
  
  // Run manager
  G4RunManager * runManager = new G4RunManager;

  // UserInitialization classes
  ExN02DetectorConstruction* ExN02detector = new ExN02DetectorConstruction;
  runManager->SetUserInitialization(ExN02detector);
  runManager->SetUserInitialization(new ExN02PhysicsList);
  
#ifdef G4VIS_USE
  // Visualization, if you choose to have it!
  G4VisManager* visManager = new ExN02VisManager;
  visManager->Initialize();
#endif
   
  // UserAction classes
  runManager->SetUserAction(new ExR05RunAction(myRecords));
  runManager->SetUserAction(new ExN02PrimaryGeneratorAction(ExN02detector));
  
  ExR05EventAction* eventAction = new ExR05EventAction(myRecords);
  runManager->SetUserAction(eventAction);
    
  // User interactions
    G4UImanager * UI = G4UImanager::GetUIpointer();  

  if(argc==1)
  // Define (G)UI terminal for interactive mode  
  { 
    // G4UIterminal is a terminal with tcsh-like edit and history features.
    G4UIsession * session = new G4UIterminal(new G4UItcsh);
    UI->ApplyCommand("/control/execute prerun.g4mac");    
    session->SessionStart();
    delete session;
  }
  else
  // Batch mode
  { 
    G4String command = "/control/execute ";
    G4String fileName = argv[1];
    UI->ApplyCommand(command+fileName);
  }

#ifdef G4VIS_USE
  delete visManager;
#endif
  delete runManager;
  delete myRecords;

  return 0;
}
