// ExR06RootPersistency.cc
// 29-Sep-2000 Bill Seligman
// This is an example class for booking histograms of hit information
// in GEANT4.

#include "ExR06RootPersistency.hh"

// Include files for ROOT.
#include "Rtypes.h"
#include "TROOT.h"
#include "TFile.h"
#include "TTree.h"

// Needed to convert numbers to strings
#include <strstream>
#include <string>

// Include files for the G4 classes
#include "globals.hh"
#include "G4Run.hh"
#include "G4Event.hh"

// Classes needed for access to convert events.
#include "ExR05PersistentRootEvent.hh"

ExR06RootPersistency::ExR06RootPersistency() {

  // Since we're not creating the TROOT object in the same scope as we're
  // creating our histogram objects, we must declare it to be static.
  // Otherwise, the TROOT object will go away when the constructor is over.

  // Note: an alternative would be to create rootBase in the main program
  // (exampleR05.cc).  But if we did that, the main program would "know" that
  // ROOT is being used to make histograms (as opposed to HBOOK, LHC++, etc.).
  // I'd rather keep that information internal to this class.
  static TROOT rootBase("simple","Test of ROOT persistent I/O");

  // Open a new ROOT file.
  m_rootFile = new TFile("exampleR06.root","RECREATE","Demo ROOT file with eventss"); 
}

ExR06RootPersistency::~ExR06RootPersistency() {

  // Close the file. Note that this is automatically done when you leave
  // the application.
  m_rootFile->Close();

  // We created the file with "new", so we have to destroy it with "delete":
  delete m_rootFile;
}


void ExR06RootPersistency::RecordBeginOfRun(const G4Run* a_run)
{
}


void ExR06RootPersistency::RecordEndOfRun(const G4Run* a_run)
{
}


void ExR06RootPersistency::RecordEndOfEvent(const G4Event* a_event)
{  
  // Convert a G4 event into a ROOT-compatible event.
  m_rootEvent = new ExR05PersistentRootEvent(a_event);

  // Write the event.
  m_rootEvent->Write();

  // We don't need the converted event anymore.
  delete m_rootEvent;
}
